.H 1 "Frame Windows"
.P
Frame windows examine and modify C data structures
in the context of an activation record.
Each activation record has its own Frame window so there is no
ambiguity in deciding which instance of a variable should be used when
expressions are evaluated.
Expressions evaluated in a Frame window see the same name space and
values that code in the function associated with the activation
record would see when it is executing.
The name space is uniquely determined by the selection of the window!
.P
A Frame window's menu bar allows the function's local variables and arguments
to be evaluated while the keyboard language accepts C expressions.
The line menus provide extensive facilities for formatting the display and
browsing through the data structures.
Each variable has formatting attributes that allow you to specify how
all future references to that variable should be displayed.
The window provides several specialized line menus and keyboard languages
that are appropriate for the type of the expression.
For example, the line menu for a variable that is a struct contains
entries for displaying each member.
.P
Unlike the other types of windows, the number of Frame windows a process
may have is a dynamic property of the state of the process.
As new function calls place activation records on the stack,
new Frame windows may be opened.
If an open Frame window's activation record disappears because the
function returns, the window is closed.
.H 2 "Frame Layout"
.P
The title bar in a Frame window identifies the activation record
that the window corresponds to by displaying the function's name and arguments,
and the symbolic value of the program counter.
This is the same information displayed on the activation record's line
in the Process window.
The title bar is updated whenever the process stops.
.P
Most lines in a Frame window display C expressions and their values,
and have the following format:
.DS I N
expression=value[=value...]
.DE
.P
The expression's value may be displayed several times in different formats,
depending on the formatting options that have been selected from the
line's menu.
Assignment operators ("=") within the expression are displayed with the
character sequence ":=" (inherited from Pascal) to distinguish it from
the "=" used to delimit the expression from its value.
For example, the line:
.DS I N
(i:=10)=012=0xA=10
.DE
.P
assigns the value 10 to the integer variable i.
Here i's formatting options are set so it is displayed in octal,
hexadecimal, and signed decimal.
.P
Other lines, such as
.DS I N
typeof(argv): **char
.DE
.P
display information about the expressions.
.P
The Frame window provides specialized line menus and keyboard
languages that depend on the expression's type, making it simple to
explore data structures in the program. For example, a line
correponding to an array provides a special keyboard syntax for displaying
all the members in a specified index range.
.P
Lines that start with the special character sequence ">>>" are spies.
Normally, an expression is only evaluated when it is entered into the
window from the keyboard or menus, or the "eval $" entry is selected
in its line menu.
However, by making an expression a spy with its line menu,
pi automatically updates its displayed value (see "Spies").
.H 2 "Frame Menu Bar"
The menu bar in a Frame window has entries that allow you to examine
the activation record's local variables and arguments, see the source
code for the activation record, open the Frame window for the
activation record's caller, and to reevaluate any spy expressions.
The "frame" pull-down menu contains the following entries:
.VL 16 1
.LI "src text"
Open the Source Text window for the file containing the activation
record's function and select the source line that corresponds to the
record's current instruction.
The file that will be opened and source line that will be selected
can be determined from the symbolic address displayed in the
window's title bar.
This entry only appears if symbolic source file and line information
is available for the function.
.LI "caller's frame"
Open the Frame window for the next activation record on the
stack (the function's caller).
This entry does not appear in the menu for the Frame window that
corresponds to the oldest activation record on the stack,
which is usually a call to main().
.LI "changed spies"
Reevaluate and redisplay all the spy expressions in this window.
Pi automatically reevaluates spy expressions whenever the process stops,
or once a second if the process is running, so this entry is normally
not be needed.
However, you may want to reevaluate the spy expressions if the process
is stopped and you change the values of some variables from
a different Frame window or the Memory window.
Also, if some of the memory is shared with another process the
memory may change while the process is stopped.
.LE
.P
The "vars" pull-down menu contains the following entries:
.VL 10 1
.LI "all"
Display the values of all the variables listed in the "vars" menu.
This is equivalent to selecting every variable entry in the "vars" menu.
.LI "variable storage_class"
.br
Selecting a variable's menu entry causes that variable to be
displayed on a new line in the window.
The storage class tells whether the variable is an argument, automatic, 
register, static that is private to the function, or static
that is private to the file.
A menu entry appears for each local variable and argument declared
in the function, as well as the external static variables declared
in the file containing the function.
The menu entries are sorted alphabetically.
.P
Selecting one of these menu entries more than once displays
that variable multiple times, allowing you to keep previous values
of the variable displayed in the window.
If you want to update the value of a displayed variable without creating
a new line, select the "eval $" entry in its line's menu.
.LE
.P
The "regs" menu contains the following entries:
.VL 10 1
.LI "all"
Display the values of all the registers in the "regs" menu.
This is equivalent to selecting all the other entries in the "regs" menu.
.LI "$regname"
Every processor register has an entry in the menu.
Choosing a register entry displays that register's value
in the context of the activation record.
When registers that are used to hold C variables are displayed,
their values are what the code for that activation record would see
when it executes.
If any of the more recent activation records saved those registers on
the stack so the registers could be reused, pi recovers the saved values.
As a result, the same register may have different values in different
Frame windows.
Scratch registers and other registers that are not saved by
function calls always display their current value.
.P
The register sub-menu generated depends on the machine's architecture.
See "Processor Dependencies" for the names of the registers on different
architectures.
.LE
.P
The possible storage classes that appear in the "variable storage_class"
menu entries are:
.VL 10 1
.LI "arg"
An argument to the function.
.LI "aut"
A local automatic (auto) variable.
.LI "reg"
A register variable or argument.
.LI "sta"
A static variable declared in the function.
.LI "Sta"
An external static variable declared in the
source file containing the function.
.LI "Glb"
A global.
Global variables will only appear in the window menu for the Globals window.
.LE
.P
For example, the C code on the left below generates the "vars" pull-down menu
on the right for one of f()'s Frame windows:
.DS I N
C code					"vars" Menu
---------------------			-----------
static int i;				all
					i Sta
f(j, k)					j arg
int j;					k reg
register k;				l aut
{					m reg
	int l;				n sta
	register m;
	static int n;
	/* code */
}
.DE
.P
Trailing "'" characters are placed after a variable's name in the "vars"
menu if the same name is declared several times in different scopes
within a function.
For example:
.DS I N
C code					"vars" Menu
------------------------------		-----------
static int i;				all
					i     Sta
f(i)					i'    arg
int i;					i''   aut
{					i'''  sta
	{				i'''' reg
		register int i;
	}
	{
		static int i;
	}
	{
		int i;
	}
}
.DE
.P
In this case it is possible to decide the correspondence between an i in the
menu with the i in the code by its storage class.
Expressions typed from the keyboard that contain i use the instance
of the variable with the most trailing "'" characters in the menu if the
name is overloaded. Here, the i declared as a register would be used.
It is not possible to access the other i variables from the keyboard - only
the menu entries can be used to access them.
.P
If all the i variables are have the same storage class,
it may take some detective work to determine the menu to source code
correspondence.
Disassembling the source statements or trying to deduce the correspondence
by the variables' values usually works.
However, authors of such convoluted code deserve to have
some difficulty debugging their programs.
.H 2 "Frame Keyboard"
Syntax
.DS I N
C expression
.DE
.P
A Frame window's keyboard language allows you to type in C expressions
to be evaluated in the context of the window's activation record.
After evaluation, the expression and its current value are displayed
on a new line in the window.
A displayed expression may be reformatted or reevaluated from its line menu.
It is not necessary to stop the process before evaluating expressions.
They can be evaluated on-the-fly, with minimal impact on the timing of
the running process.
.P
The expressions may be constructed from identifiers,
C constants (character, integer, explicit long and float),
function calls and most (but not all) of the C operators.
The following table shows the operators accepted by the grammar,
along with their precedence and associativity.
Operators on the same line have the same precedence and rows are in 
order of decreasing precedence.
.DS I N
Operator		Associativity
----------------	-------------
() [] -> .		left to right
! ~ - * & sizeof	right to left
* / %			left to right
+ -			left to right
<< >>			left to right
< <= > >=		left to right
== >!=			left to right
&			left to right
^			left to right
|			left to right
&&			left to right
||			left to right
=			right to left
,			left to right
.DE
.P
The only differences between this precedence table in the one in book,
"The C Programming Language" [Kernighan 78], are:
.AL 1
.LI
The prefix and postfix operators ++ and -- are not supported.
.LI
The cast operator
.DS I N
( type-name ) expression
.DE
.P
is not accepted.
However, the window's line menus can be used to perform casts on expressions.
.LI
The conditional operator
.DS I N
expression ? expression : expression
.DE
.P
is not accepted.
.LI
Compound assignment operators of the form:
.DS I N
expression op= expression
.DE
.P
such as += and -= are not supported.
Only simple assignments are accepted.
.LE
.H 3 "Identifiers"
.P
When searching for identifiers that are variable names pi searches
the following name spaces in sequence to locate the variable:
.AL 1
.LI
The local name space for the function corresponding to the Frame window.
This includes the function's arguments and local, auto, and static variables
declared inside the function.
The values of the machine's registers are accessible by preceding 
the register name with the character `$'.
See "Processor Dependencies" for the names of registers on
different processor types.
.LI
The name space of external static variables declared in the file
containing the source code for the function.
.LI
The global name space for the process.
This includes all the C external variables.
.LE
.P
To allow the use of pi with de-mangled C++ names identifiers are allowed to
have the character sequence "::" embedded in them, even though it is
illegal in C.
.P
The keyboard language provides a special syntax that allows expressions
to access local variables in other activation records.
.DS I N
{ expression } function
.DE
.P
evaluates the expression in the context of the closest older
activation record on the stack for the named function.
For example, if the function main() contains the local variable i and
calls the function a(), that contains the local variable j, you may
type the expression:
.DS I N
j + {i}main
.DE
.P
in a()'s Frame window to add the value of j in a() to the i in main().
.P
The search for activation records that correspond to the named
function starts at the caller of the Frame window's activation
record (the activation record that is on the line below the Frame
window's activation record in the Process window), and continues until
an activation record for the function is found or the oldest record
on the stack is reached.
If the function has been called recursively and has multiple activation
records on the stack, the expression will be evaluated in first activation
record found.
If the search makes it to the oldest activation record without finding
a record associated with the function, the expression is evaluated in
a context that only allows the function's static variables to be accessed.
It is not possible to access the arguments or local
variables in activation records that are more recent than the current
Frame window's using the "{expression}function" syntax.
.H 3 "Function Calls"
The Frame window keyboard language allows function calls be included
in expressions.
When a function call is encountered pi runs the function at full
speed with all breakpoints removed, and uses the results returned by the
function in the expression.
If the function call does not return after running for 15 seconds,
the call is aborted.
.P
To be able to evaluate a function call in an expression,
several conditions must be met:
.AL 1
.LI
The function must be compiled with the -g option.
Pi uses the type information generated by the -g option to check both
the type and number of arguments given to the function call,
as well as the return type.
.LI
The process must be stopped.
However, it is okay to have function calls in conditional
breakpoint expressions, or as spy expressions when statement or
instruction stepping, since the process will be stopped when the
function call is evaluated.
An error message of the form:
.DS I N
function(): context save: process not stopped
.DE
.P
is be printed in the window if the process is running and you
try to evaluate an expression containing a function call.
Function calls are not allowed when core dumps are examined.
.H 3 "Built-In Functions"
The Frame window keyboard language also provides two functions that
are built into the grammar.
.DS I N
typeof(expression)
.DE
displays the type of the given expression.
If the expression is a variable, the type information is extracted from
the symbol table.
Otherwise, the type of the evaluated expression's result is displayed.
The following table shows some C variable declarations and
how typeof displays their type:
.DS I N
Declaration		Displayed by typeof
---------------		-----------------------
char c;			typeof(c): char
char *cp;		typeof(cp): *char
char ca[5][10];		typeof(ca): [5][10]char
*cpa[10];		typeof(cpa): [10]*char
.DE
.P
In addition, the built-in function
.DS I N
double fabs(double d)
.DE
.P
returns the absolute value of its argument d.
.H 2 "Frame Lines"
The line menus and keyboard languages allow you to explore
the data structures and vary depending on the type of
the expression.
For most lines the keyboard language accepts the same C expressions
as the Frame window's keyboard language, with the exception that the
identifier $ is a shorthand to represent the expression on the
current line.
For example, if the currently selected line contains an expression
that points to a variable that is accessed by following many pointers
in a linked list, you may assign 0 to that variable by simply typing
.DS I N
$=0
.DE
.P
rather than retyping in the whole thing.
Some types of lines, like those used to index array elements,
provide specialized keyboard languages that allow simple input sequences
to be used to perform complex operations.
.P
The line menus for the various expressions depend on the expressions' type,
and are described in the sections that follow.
Within the menus, the character `$' is used to represent
the selected expression.
.H 3 "Basic Data Types"
The line menu for the basic data types,
such as chars, shorts, ints, longs, floats and doubles contains the entries
shown below.
Many of these entries will also appear in the line menus for other
types of expressions.
.VL 12 1
.LI "spy on $"
Make the selected expression a spy (for more on spies see "Spies").
The line is redisplayed with the characters ">>>" inserted at
the beginning.
This menu entry is not present if the current expression is already a spy
or if a core dumps is being examined.
.LI "unspy $"
Turn off spying for the selected expression.
This menu entry only appears for expressions that are spies.
.LI "eval $"
Reevaluate and redisplay the selected expression.
Useful if the expression is not a spy and you want to update its value.
.LI "& $"
On a new line, create and display a new expression by taking
the address of the selected expression.
.LI "mem .=$"
Open the Memory window and use the value of the current
expression as the address of the memory location to examine.
This menu entry is not present if the value of the current expression is 0.
.LI "cast $"
This sub-menu allows you to cast the selected expression into a different
data type or into a pointer to a different data type.
See "Casting".
.LI "typeof $"
Display the type of the selected expression.
.LI "sizeof $"
Display the size of the selected expression.
If the expression is a variable the size in bytes of the memory
space allocated for that variable is displayed.
If the expression is not a lvalue (you can't apply the
address operator & to it), the size of the expression's result is displayed.
.LI "format"
This sub-menu allows you to choose the format used to display
the selected expression.
See "Format Menus" below.
.H 3 "Format Menus"
The format sub-menus allow you to change the format used to
display an expression.
Each menu contain sa list of different formats that
are applicable to the type of the expression.
.P
Choosing a formatting entry causes the expression to be
reevaluated and displayed with the newly selected format.
Menu entries for formatting options that are currently enabled
allow you to turn that option off, while entries for formatting
options that are disabled allow you to turn that option on.
If multiple formatting options are turned on,
each format displayed on the line will be separated
from the others with the `=' character.
.P
If the expression is a C variable,
setting the format field affects the future display of
all instances of that variable.
For example, setting the format field for an argument to a
function will not only affect how that variable is formatted
on the current line, but also
in the activation records listed in the Process window,
in conditional breakpoint expressions in Source Text windows,
and in the title bars of Frame windows.
Similarly, if the format attributes are set for a member
of a struct or union, they will be used when
displaying all future instances of that struct or union.
.P
The possible formats are described below:
.VL 18 1
.LI "hex on|off"
Display the number in hexadecimal.
.LI "unsd_dec on|off"
Display the number as an unsigned decimal number.
.LI "sign_dec on|off"
Display the number as a signed decimal number.
.LI "octal on|off"
Display the number in octal.
.LI "ascii on|off"
Display the number as a sequence of ASCII characters.
The number of characters displayed depends on the size of the type.
Chars display 1 character, shorts 2 characters, and ints, longs,
and floats 4 characters.
.LI "float on|off"
Display the number as a float.
Up to 6 decimal places are used.
.LI "double on|off"
Display the number as a double.
Up to 15 decimal places are used.
.LI "time on|off"
Treat the number as a Unix representation of
time (the number of seconds since the epoch 00:00:00 GMT, January 1, 1970),
and display it as an ASCII date and time.
.LI "symbolic on|off"
Display the number as a symbolic address.
It will appear in one of the following formats:
.DS I N
file:linenumber+offset
function()+offset
global+offset
.DE
.P
depending on whether the address points to a text (instruction) location
for which symbolic file and line information is available,
a text address for which symbolic line information is not available,
or a data address.
.LI "`ascii' on|off"
Display the characters referenced by the character pointer or
in the character array as a C string.
The string is terminated by the first null character reached,
and is limited in length to 20 characters.
If the string contains more than 20 characters, the string
terminates with the special character sequence "..." to indicate
there is more.
This entry is mutually exclusive of the ``"wider" on|off'' entry.
.LI "`wider' on|off"
Same as the entry ``"ascii" on|off'' except the length of the
string is limited to 200 characters instead of 20.
Used when you want more of a long string displayed.
This entry is mutually exclusive of the ``"ascii" on|off'' entry.
.LE
.P
The default formatting options for the basic data types
are listed below:	
.DS I N
Type		Default Format
--------------------------------
char		ascii, sign_dec
short		sign_dec
int		sign_dec
long		sign_dec
float		float
double		double
unsigned char	ascii, unsd_dec
unsigned short	unsd_dec
unsigned int	unsd_dec
unsigned long	unsd_dec
char*		hex,"ascii"
unsigned char*	hex,"ascii"
other*		hex
.DE
.P
If only a single formatting option is on for an expression,
and you attempt to turn it off, the formatting options for
that expression will be reset to the default for its type.
.H 3 "Casting"
The casting sub-menu allows expressions to be converted from one data
type to another.
Casting is not allowed from the keyboard and must be done from the line menus.
While in most circumstances the type information maintained by the symbol
table makes casts unnecessary, there are several circumstances that
require their use:
.AL 1
.LI
A variable's type information in the symbol table may be wrong
if the variable was declared in a source file that was not
compiled with the -g option.
These variables
usually have their type field set to int or long,
regardless of their real type.
.LI
In C, it is common to use a single type of pointer
to point to different types of objects.
For example, a generic linked list package may use a "char *" to point to all
types of objects.
.LI
If a C++ base class function is called for an instance of a derived class,
you may want to cast the "this" argument for the function from a
pointer to a base class object back into a pointer to a derived
class object, allowing symbolic access to all its members.
Note, that while this works for derived classes that
use single inheritance, it may not work with multiple inheritance.
.LE
.P
There are no int entries in the casting sub-menu as it
is assumed that ints are the same size as either shorts or longs.
.VL 12 1
.LI "char"
Cast the selected expression into a char.
.LI "*char"
Cast the selected expression into a pointer to a char.
.LI "short"
Cast the selected expression into a short.
.LI "*short"
Cast the selected expression into a pointer to a short.
.LI "long"
Cast the selected expression into a long.
.LI "*long"
Cast the selected expression into a pointer to a long.
.LI "float"
Cast the selected expression into a float.
.LI "*float"
Cast the selected expression into a pointer to a float.
.LI "double"
Cast the selected expression into a double.
.LI "*double"
Cast the selected expression into a pointer to a double.
.LI "* ?"
Cast the selected expression into a pointer to a type
that will be specified later.
This menu operator casts expressions into pointers to pointers.
When this entry is selected a new line is created in the format:
.DS I N
(* ? )expression
.DE
.P
and the new line's menu is the cast menu.
Choosing an entry in the new line's cast
menu creates another new line and replace the `?' character
in the line with the cast type selected, and then perform the cast.
For example, if the global variable "char **environ",
that points to the programs environment variables, was not declared in a
file that was compiled with the -g option,
the symbol table will falsely believe that its
type is a long.
You may cast it back into its correct type by:
.AL 1
.LI
Entering the expression "environ" from the keyboard.
.LI
Choose the menu entry "* ?" in the cast sub-menu for that line.
A new line:
.DS I N
(* ? )environ
.DE
.P
is inserted in the window and selected.
.LI
Choose the entry "*char" in the new line's menu and another new line:
.DS I N
(** char)environ=value
.DE
.P
is inserted into the window.
.LE
.P
If you select the "* ?" entry in the menu for a line of the type
.DS I N
(* ? )expression
.DE
.P
a new line of the form
.DS I N
(** ? )expression
.DE
.P
is be inserted in the window,
allowing you cast the expression into a pointer to a
pointer to a pointer.
You may repeat this operation as many times as needed.
.P
Although you may also use the "* ?" menu entry to cast
an expression into a pointer to
a basic data type, it is simpler to just choose a pointer
entry in the original cast menu.
.LI "*struct ?"
Cast the selected expression into a pointer to a structure or union.
A new line of the form:
.DS I N
(*struct ? )expression
.DE
.P
is inserted in the window and selected,
indicating you need to specify the tag name
of the structure or union.
The tag name may be entered from either the keyboard or line menu.
The keyboard language for the new line only accepts tag names.
When a tag name is entered, a new line is inserted in the window
with the `?' replaced by the tag
name and the cast is performed.
.P
Alternatively, a tag name may be selected from the line's menu.
The menu will have an
entry for every struct and union tag name found in the symbol table.
Selecting one of these entries is equivalent to typing that
tag name in from the keyboard.
.P
Unnamed structures have names generated for them automatically.
The format of these names is system dependent.
.LI "enum ?"
Cast the selected expression into an enum.
This menu entry behaves just like
"*struct ?", except enum tag names are substituted for
struct and union tag names.
.H 3 "Arrays"
The line menu for an array is the same as the line menu for the
basic data types except the cast operator is not in the menu as it is
impossible to cast an array into a different data type.
However, you may take the address of an array and subsequently
cast that into a pointer to a different type.
.P
In addition, an array's line menu provides an entry, "$ []", that
allows to you to access
the elements of the array.
When this operator is chosen, a new line of the form:
.DS I N
expression[ ? ]
.DE
.P
is placed in the window and selected.
This line's menu lists indices from -2 to 20 and selecting an entry
will display that element of the array on a new line.
This same menu is generated when pointers are treated as arrays.
The negative indices display elements that are located before
the start of the array and are useful with pointers
that have been incremented since
it is often desirable to see what was previously pointed to.
.P
The keyboard language of a "expression[ ? ]" line
provides an alternative way to enter an array index.
The language accepts input in the form:
.DS I N
low[..high]
.DE
.P
where both low and the optional high are expressions
that must have integer values.
If only low is present, its value is used as an array index,
and that array element will be displayed on a new line.
This allows you to enter an array index that is not in the range
of the line menu, or is constructed from an arbitrary C expression.
.P
If the low..high format is entered, all the elements from low
to high are displayed on new lines.
For example, to display the first 10 elements of an array
with a single command, type:
.DS I N
0..9
.DE
.P
The ".." operator used in the keyboard grammar has lower
precedence than any of the C operators.
.H 3 "Pointers"
The line menu for a pointer displayed in a Frame window
is just like an array's, except the "cast" sub-menu is
present and an additional entry, "* $", allows you to dereference
the selected expression.
The "$ []" menu entry treats the pointer as an array,
and is useful for dereferencing all the elements in the vicinity of the pointer.
For example, to display what the
pointer points to, as well as the five elements before and after it:
.AL 1
.LI
Select the pointer's line and choose the "$ []" menu entry.
This creates and selects a new line of the form:
.DS I N
pointer[ ? ]
.DE
.LI
Type the command
.DS I N
-5..5
.DE
.P
to the new line to display the elements from 5 locations
before the pointer to 5 locations after.
.LE
.H 3 "Structures and Unions"
The Frame window provides extensive facilities for displaying
and exploring the data in structures and unions.
A structure or union's line menu contains entries that allow each
of its members to be displayed.
These entries, along with the "typeof $" menu entry and User
Types window,
provide a powerful way to explore data structures you know little about.
.P
For each struct and union pi maintains a template
of how to display an instance of that type.
The template consists of:
.AL 1
.LI
A list of the members that should be displayed.
.LI
A list of formatting options for each member.
.LE
.P
The current display list and formatting options for
a particular struct or union can be viewed by choosing its tag
name in the menu bar of the User Types window.
.P
The initial list of members to display consists of the first
two members in the declaration
for that type, and can be modified several ways.
Members can be explicitly added to the
list by using the line menus in the User Types window.
Alternatively, a member 
may be added implicitly by displaying an expression in a
Frame window that accesses that member.
If you access a member of a struct or union in an expression in a
Frame window, either by typing in a C expression from the
keyboard or by creating it
with the line menus, that member is automatically added to the
list of members to display for that type.
When any instance of that struct or union type is displayed in
the future, that member will be shown.
Once a member is in the list of members to display,
it can only be removed from the list with the line menus
in the User Types window.
.P
The formatting options used to display a member of a structure
or union are initially set to the default settings for its data type
(see the "Format Menus" section), and may also
be modified from the line menus in either the User Types
or Frame windows.
If an expression in a Frame window displays a member of structure or union,
changing its displayed format with the "format" sub-menu changes
that members formatting options in the template.
The formatting option selected affects the future display of that 
member in all instances of that structure or union,
not just in the selected expression.
.P
As an example we look at how pi displays the example of a
structure given in the "The C Programming Language" [Kernighan 78].
If our program contains the code:
.DS I N
struct date {
	int	day;
	int	month;
	int	year;
	int	yearday;
	char	mon_name[4];
};

struct date d = { 4, 7, 1776, 186, "Jul" };
.DE
.P
and we ask pi to display the structure d in a Frame
window (either by typing the expression d to the window,
or selecting d in its window menu), d is displayed as:
.DS I N
d={day=4,month=7}
.DE
.P
The default format for a date structure displays the first two members,
day and month, as signed decimal numbers since they are both declared as ints.
.P
The line menu for this expression includes most of the operators
provided for the basic types along with some new ones, explained below:
.VL 15 2
.LI "spy on $"
Make the selected expression a spy (see "Spies").
This is equivalent to spying on each of the members that are
in the template's display list.
.LI "eval $"
Evaluate and display all the members in the structure or
union that are in the template's display list.
.LI "$.id"
This sub-menu allows members of the structure or union to be examined.
.LE
.P
The "$.id" sub-menu entries are.
.VL 15 2
.LI "$.*"
Display all the members of the struct or union on the selected line,
adding them all to the list of members to display for that type.
.LI "$.member"
For each member of the struct or union there will be a menu entry in
this format. 
Choosing one of these entries displays that member
on a new line in the window and
adds that member to the list of members to display for that type.
The entries are sorted alphabetically in the menu.
.LE
.P
If a structure or union has only a few entries,
the "$.member" and "$.*" menu entries are placed directly in the line menu,
and the "$.id" sub-menu is not created.
While you may not cast a structure or union into a different type directly,
if you take its address with the "& $" menu operator,
the new line's menu will allow you to perform casts.
.P
If in the example above, if we choose the "$.year" menu entry, the line:
.DS I N
d.year=1776
.DE
.P
is inserted into the window.
Since this operation adds year to the list of members to
display for a date structure, if we select the line displaying d and
choose the "eval $" menu entry, the line is redisplayed as:
.DS I N
d={day=4,month=7,year=1776}
.DE
.P
Similarly, reselecting the line containing "d.year=1776" and
choosing the "hex on" menu entry in its "format" sub-menu,
redisplays the line as:
.DS I N
d.year=0x6F0=1776
.DE
.P
As the format selection also becomes part of the template
for the date structure, reselecting the line displaying d and again
choosing the "eval $" menu entry redisplays that line as:
.DS I N
d={day=4,month=7,year=0x6F0=1776}
.DE
.P
To remove a member from the list of members to display you must
.AL 1
.LI
open the User Types window.
.LI
choose the structure or union's tag name in the window menu.
.LI
and then choose the "hide" entry in the line menu for that member.
.LE
.P
See "User Types" for a detailed description of these operators.
.P
These techniques allow to you to specify exactly which members
of a structure or union are displayed, and how they are formatted.
When structures have large numbers of entries, you can customize
the display so only the members of interest are shown.
.P
If an expression is a pointer to a structure or union,
additional line menu entries allow you to cast the structure pointer into
other types and look at the structure's memory from the Memory window.
.VL 10 1
.LI "* $"
Dereference the pointer, and on a new line display the structure
or union as describe by its template.
Only members in the template's list of members to display are evaluated.
.LI "$ []"
Treat the structure pointer as an array of structures. See the "Arrays" section for the description of this operator.
.LI "$->id"
This sub-menu allows access to all the members of the structure or union,
and is analogous to the "$.id" sub-menu for an expression that is a structure.
The selection of the "$->*" menu entry displays all the members
of the structure or union on a new line, instead of the current one.
.LI "format"
This entry determines the format used to display the pointer,
not the contents of the structure or union.
.LE
.H 3 "Enumerations"
By default, an enum expression displays its value symbolically.
For example, if b is an enum variable, and its current value is ACTIVE,
it is displayed as:
.DS I N
b=ACTIVE
.DE
.P
If the value of an enum expression is out of
range (it contains a value for which there is
no enumeration identifier), the current value is displayed as a cast:
.DS I N
b=(enum Behavs)10
.DE
.P
An enum's line menu contains the same entries as the line menu for an int,
except the format menu has a "symbolic" entry instead of a "time" entry.
By default, only the "symbolic" format is on.
Turning a non-symbolic format entry on allows you to see
the enumeration identifier's value.
For example, selecting the "sign_dec on" menu entry for the "b=ACTIVE" 
line redisplays it as:
.DS I N
b=3=ACTIVE
.DE
.P
When assigning values to an enum expression you may type
in the enumeration value
symbolically, or as a number.
.H 3 "Non-Lvalue Expressions"
.P
A non-lvalue expression is a C expression that you can not take
the address of, or put on
the left side of an assignment statement.
Non-lvalue expressions generate line menus identical to the menus for
the basic types (presented in "Basic Data Types") except
the "& $" entry is missing.
The "format" sub-menu generated depends on the expression's type.
.P
Expressions constructed from a single integer constant
are useful for converting constants to different formats.
For example, if the hexadecimal constant 0x1234 is typed
to the window, it is displayed as:
.DS I N
0x1234=4660
.DE
.P
It is converted to a decimal number on the display
line since that is the default format for an int expression.
To convert it to octal select the "octal on" entry
in the "format" sub-menu, and the line is redisplayed as:
.DS I N
0x1234=011064=4660
.DE
.H 3 "Spies"
Expressions displayed in Frame windows are not updated unless
you explicitly request that the expression be reevaluated by
choosing the "eval $" line menu entry.
However, if an expression is made into a spy expression by choosing
the "spy on $" menu entry, pi reevaluates and
updates its displayed value automatically.
.P
The frequency spy expressions are updated depends on what
the debugger is doing to the process.
When instruction stepping from the "instr" menu, spy expressions are
updated after each instruction step.
When statement stepping from the "stmt" menu, they are updated
after each statement step.
Because it usually takes many instructions to implement a single statement,
spy expressions are checked less frequently when
statement stepping.
.P
If the process is not being stepped, spy expressions are reevaluated
every time the process stops.
This may be caused from hitting a breakpoint, tracepoint, or conditional 
breakpoint, or from there being a signal pending for
the process (from an outside source
or from a "stop" request sent from the Process window).
When conditional breakpoints are hit, spy expressions are reevaluated
even if the breakpoint condition is false and the process is restarted.
.P
Finally, if the process is running and not hitting any
conditional breakpoints or tracepoints, spy expressions are updated
once a second - the same frequency that the status
line in the Process window is updated.
.P
If the values of any spy expression change from their previous values,
the lines containing the expressions are
selected by the debugger and one of the messages:
.DS I N
1 spy changed
number spies changed
.DE
.P
is inserted at the beginning of the status line in the Process window,
depending on how many spy expressions have changed.
In addition, if the process was being statement or instruction stepped,
or at a tracepoint or a conditional breakpoint when the value of the
spy expression changed, the process is stopped.
.P
One way to view spy expressions is that they are conditional breakpoints,
with the condition being the value of the expression is different from
the last time it was evaluated,
that are placed at every instruction, statement, or tracepoint,
depending on how you execute the process.
For example, if you have a wandering pointer that is changing
the value of a variable, but you don't know where the bad code is,
you can make the variable a
spy to locate the faulty instructions.
Stepping instructions will locate the exact instruction that
changes the variable, but the overhead of evaluating spies
after each instruction makes it impractical to use
if large numbers of instructions must be executed
before the variable changes.
Stepping statements has less overhead, as the spies are
only evaluated after each statement and function calls
are stepped over at full
speed, but it does not localize the faulty code as well.
If the fault occurs in a deeply nested function call,
the statement the process stops at may be far removed from the
statement that caused the error.
Tracepoints allow you to specify exactly where the spy
expressions are evaluated, and can be used efficiently when
you have a good idea where
the problem is.
.P
If a running process does not hit any conditional breakpoints
or tracepoints after executing for one second,
spy expressions are reevaluated and redisplayed, but the process is
not stopped if any of their values change.
In this case, the changed spy expressions do
not stop the running program for two reasons. 
.AL 1
.LI
If it were stopped, the current location in the program would
most likely have little to do with the changing of the spy expression.
Millions of instructions may have executed between the time
expression changed values and the spy expression was evaluated.
.LI
The automatic redisplay of changed spy expressions
every second without stopping
the program can be useful when debugging code that
explicitly depends on the program's timing.
This feature allows you to monitor expressions in real-time, with
minimal impact on the running program.
.LE
.P
If you are using spies to monitor expressions once a second
in real-time, their are two restrictions that apply to them:
.AL 1
.LI
They may not contain any function calls,
as pi cannot evaluate expressions containing function calls
unless the process is stopped. 
.LI
Because pi does not update it's list of activation records
until a process stops, you
should be careful not to spy on local variables in activation records
that will disappear when the program is resumed.
If a spy expression includes such a variable, pi
will continue to update the expression as if the activation
record were still present,
but the value it reads will be determined by
whatever the program uses that memory
location on the stack for, and will most likely have
nothing to do with the original variable. 
